/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.arrays;

import java.lang.foreign.MemorySegment;
import java.lang.management.ManagementFactory;
import java.util.List;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.api.types.arrays.CharArray;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.HalfFloatArray;
import uk.ac.manchester.tornado.api.types.arrays.Int8Array;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;

public abstract sealed class TornadoNativeArray
permits ByteArray, CharArray, DoubleArray, FloatArray, HalfFloatArray, IntArray, LongArray, ShortArray, Int8Array {
    public static final long ARRAY_HEADER = Long.parseLong(System.getProperty("tornado.panama.objectHeader", TornadoNativeArray.getDefaultHeaderSize()));

    private static String getDefaultHeaderSize() {
        List<String> jvmArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
        boolean isUncompressed = jvmArgs.contains("-XX:-UseCompressedOops") || jvmArgs.contains("-XX:-UseCompressedClassPointers");
        return isUncompressed ? "24" : "16";
    }

    static void ensureMultipleOfElementSize(long byteSize, long elementSize) {
        if (byteSize % elementSize != 0L) {
            throw new IllegalArgumentException(String.format("The byte size (%d) is not a multiple of the element size (%d)", byteSize, elementSize));
        }
    }

    public abstract int getSize();

    public abstract MemorySegment getSegment();

    public abstract MemorySegment getSegmentWithHeader();

    public abstract long getNumBytesOfSegmentWithHeader();

    public abstract long getNumBytesOfSegment();

    protected void clear() {
    }

    public abstract int getElementSize();
}

