/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.arrays;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;

public class TornadoMemorySegment {
    private MemorySegment segment;

    public TornadoMemorySegment(long segmentByteSize, int numElements) {
        this.segment = Arena.ofAuto().allocate(segmentByteSize, 1L);
        this.segment.setAtIndex(ValueLayout.JAVA_INT, 0L, numElements);
    }

    public TornadoMemorySegment(MemorySegment memorySegment) {
        this.segment = memorySegment;
    }

    public MemorySegment getSegment() {
        return this.segment;
    }

    public void setSegment(MemorySegment segment) {
        this.segment = segment;
    }

    public void setAtIndex(int index, float value, int baseIndex) {
        this.segment.setAtIndex(ValueLayout.JAVA_FLOAT, (long)(baseIndex + index), value);
    }

    public float getFloatAtIndex(int index, int baseIndex) {
        return this.segment.getAtIndex(ValueLayout.JAVA_FLOAT, (long)(baseIndex + index));
    }

    public void setAtIndex(int index, double value, int baseIndex) {
        this.segment.setAtIndex(ValueLayout.JAVA_DOUBLE, (long)(baseIndex + index), value);
    }

    public double getDoubleAtIndex(int index, int baseIndex) {
        return this.segment.getAtIndex(ValueLayout.JAVA_DOUBLE, (long)(baseIndex + index));
    }

    public void setAtIndex(int index, byte value, int baseIndex) {
        this.segment.setAtIndex(ValueLayout.JAVA_BYTE, (long)(baseIndex + index), value);
    }

    public byte getByteAtIndex(int index, int baseIndex) {
        return this.segment.getAtIndex(ValueLayout.JAVA_BYTE, (long)(baseIndex + index));
    }

    public void setAtIndex(int index, char value, int baseIndex) {
        this.segment.setAtIndex(ValueLayout.JAVA_CHAR, (long)(baseIndex + index), value);
    }

    public char getCharAtIndex(int index, int baseIndex) {
        return this.segment.getAtIndex(ValueLayout.JAVA_CHAR, (long)(baseIndex + index));
    }

    public void setAtIndex(int index, int value, int baseIndex) {
        this.segment.setAtIndex(ValueLayout.JAVA_INT, (long)(baseIndex + index), value);
    }

    public int getIntAtIndex(int index, int baseIndex) {
        return this.segment.getAtIndex(ValueLayout.JAVA_INT, (long)(baseIndex + index));
    }

    public void setAtIndex(int index, long value, int baseIndex) {
        this.segment.setAtIndex(ValueLayout.JAVA_LONG, (long)(baseIndex + index), value);
    }

    public long getLongAtIndex(int index, int baseIndex) {
        return this.segment.getAtIndex(ValueLayout.JAVA_LONG, (long)(baseIndex + index));
    }

    public void setAtIndex(int index, short value, int baseIndex) {
        this.segment.setAtIndex(ValueLayout.JAVA_SHORT, (long)(baseIndex + index), value);
    }

    public short getShortAtIndex(int index, int baseIndex) {
        return this.segment.getAtIndex(ValueLayout.JAVA_SHORT, (long)(baseIndex + index));
    }
}

