/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.arrays;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.LongBuffer;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.internal.annotations.SegmentElementSize;
import uk.ac.manchester.tornado.api.types.arrays.TornadoMemorySegment;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;

@SegmentElementSize(size=8)
public final class LongArray
extends TornadoNativeArray {
    private static final int LONG_BYTES = 8;
    private TornadoMemorySegment segment;
    private int numberOfElements;
    private int arrayHeaderSize;
    private int baseIndex;
    private long segmentByteSize;

    public LongArray(int numberOfElements) {
        this.numberOfElements = numberOfElements;
        this.arrayHeaderSize = (int)TornadoNativeArray.ARRAY_HEADER;
        this.baseIndex = this.arrayHeaderSize / 8;
        this.segmentByteSize = (long)numberOfElements * 8L + (long)this.arrayHeaderSize;
        this.segment = new TornadoMemorySegment(this.segmentByteSize, numberOfElements);
    }

    private LongArray(MemorySegment existingSegment) {
        this.arrayHeaderSize = (int)TornadoNativeArray.ARRAY_HEADER;
        this.baseIndex = this.arrayHeaderSize / 8;
        long dataSize = existingSegment.byteSize() - (long)this.arrayHeaderSize;
        LongArray.ensureMultipleOfElementSize(dataSize, 8L);
        this.numberOfElements = (int)(dataSize / 8L);
        this.segmentByteSize = existingSegment.byteSize();
        this.segment = new TornadoMemorySegment(existingSegment);
        this.segment.getSegment().setAtIndex(ValueLayout.JAVA_INT, 0L, this.numberOfElements);
    }

    public LongArray(LongArray ... arrays) {
        LongArray.concat(arrays);
    }

    private static LongArray createSegment(long[] values) {
        LongArray array = new LongArray(values.length);
        for (int i = 0; i < values.length; ++i) {
            array.set(i, values[i]);
        }
        return array;
    }

    public static LongArray fromArray(long[] values) {
        return LongArray.createSegment(values);
    }

    public static LongArray fromElements(long ... values) {
        return LongArray.createSegment(values);
    }

    public static LongArray fromSegment(MemorySegment segment) {
        long byteSize = segment.byteSize();
        int numElements = (int)(byteSize / 8L);
        LongArray.ensureMultipleOfElementSize(byteSize, 8L);
        LongArray longArray = new LongArray(numElements);
        MemorySegment.copy(segment, 0L, longArray.segment.getSegment(), (long)longArray.baseIndex * 8L, byteSize);
        return longArray;
    }

    public static LongArray fromSegmentShallow(MemorySegment segment) {
        return new LongArray(segment);
    }

    public static LongArray fromLongBuffer(LongBuffer buffer) {
        int numElements = buffer.remaining();
        LongArray longArray = new LongArray(numElements);
        longArray.getSegment().copyFrom(MemorySegment.ofBuffer(buffer));
        return longArray;
    }

    public static void initialize(LongArray array, long value) {
        for (int i = 0; i < array.getSize(); ++i) {
            array.set(i, value);
        }
    }

    public static LongArray concat(LongArray ... arrays) {
        int newSize = Arrays.stream(arrays).mapToInt(LongArray::getSize).sum();
        LongArray concatArray = new LongArray(newSize);
        long currentPositionBytes = 0L;
        for (LongArray array : arrays) {
            MemorySegment.copy(array.getSegment(), 0L, concatArray.getSegment(), currentPositionBytes, array.getNumBytesOfSegment());
            currentPositionBytes += array.getNumBytesOfSegment();
        }
        return concatArray;
    }

    public long[] toHeapArray() {
        long[] outputArray = new long[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            outputArray[i] = this.get(i);
        }
        return outputArray;
    }

    public void set(int index, long value) {
        this.segment.setAtIndex(index, value, this.baseIndex);
    }

    public long get(int index) {
        return this.segment.getLongAtIndex(index, this.baseIndex);
    }

    @Override
    public void clear() {
        this.init(0L);
    }

    @Override
    public int getElementSize() {
        return 8;
    }

    public void init(long value) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.segment.setAtIndex(i, value, this.baseIndex);
        }
    }

    @Override
    public int getSize() {
        return this.numberOfElements;
    }

    @Override
    public MemorySegment getSegment() {
        return this.segment.getSegment().asSlice(TornadoNativeArray.ARRAY_HEADER);
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.segment.getSegment();
    }

    @Override
    public long getNumBytesOfSegmentWithHeader() {
        return this.segmentByteSize;
    }

    @Override
    public long getNumBytesOfSegment() {
        return this.segmentByteSize - TornadoNativeArray.ARRAY_HEADER;
    }

    public LongArray slice(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > this.getSize()) {
            throw new IllegalArgumentException("Slice out of bounds");
        }
        long sliceOffsetInBytes = TornadoNativeArray.ARRAY_HEADER + (long)offset * 8L;
        long sliceByteLength = (long)length * 8L;
        MemorySegment sliceSegment = this.segment.getSegment().asSlice(sliceOffsetInBytes, sliceByteLength);
        LongArray slice = LongArray.fromSegment(sliceSegment);
        return slice;
    }
}

