/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.arrays;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.IntBuffer;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.internal.annotations.SegmentElementSize;
import uk.ac.manchester.tornado.api.types.arrays.TornadoMemorySegment;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;

@SegmentElementSize(size=4)
public final class IntArray
extends TornadoNativeArray {
    private static final int INT_BYTES = 4;
    private int numberOfElements;
    private TornadoMemorySegment segment;
    private int arrayHeaderSize;
    private int baseIndex;
    private long segmentByteSize;

    public IntArray(int numberOfElements) {
        this.numberOfElements = numberOfElements;
        this.arrayHeaderSize = (int)TornadoNativeArray.ARRAY_HEADER;
        this.baseIndex = this.arrayHeaderSize / 4;
        this.segmentByteSize = (long)numberOfElements * 4L + (long)this.arrayHeaderSize;
        this.segment = new TornadoMemorySegment(this.segmentByteSize, numberOfElements);
    }

    private IntArray(MemorySegment existingSegment) {
        this.arrayHeaderSize = (int)TornadoNativeArray.ARRAY_HEADER;
        this.baseIndex = this.arrayHeaderSize / 4;
        long dataSize = existingSegment.byteSize() - (long)this.arrayHeaderSize;
        IntArray.ensureMultipleOfElementSize(dataSize, 4L);
        this.numberOfElements = (int)(dataSize / 4L);
        this.segmentByteSize = existingSegment.byteSize();
        this.segment = new TornadoMemorySegment(existingSegment);
        this.segment.getSegment().setAtIndex(ValueLayout.JAVA_INT, 0L, this.numberOfElements);
    }

    public IntArray(IntArray ... arrays) {
        IntArray.concat(arrays);
    }

    private static IntArray createSegment(int[] values) {
        IntArray array = new IntArray(values.length);
        for (int i = 0; i < values.length; ++i) {
            array.set(i, values[i]);
        }
        return array;
    }

    public static IntArray fromArray(int[] values) {
        return IntArray.createSegment(values);
    }

    public static IntArray fromElements(int ... values) {
        return IntArray.createSegment(values);
    }

    public static IntArray fromSegment(MemorySegment segment) {
        long byteSize = segment.byteSize();
        int numElements = (int)(byteSize / 4L);
        IntArray.ensureMultipleOfElementSize(byteSize, 4L);
        IntArray intArray = new IntArray(numElements);
        MemorySegment.copy(segment, 0L, intArray.segment.getSegment(), (long)intArray.baseIndex * 4L, byteSize);
        return intArray;
    }

    public static IntArray fromSegmentShallow(MemorySegment segment) {
        return new IntArray(segment);
    }

    public static IntArray fromIntBuffer(IntBuffer buffer) {
        int numElements = buffer.remaining();
        IntArray intArray = new IntArray(numElements);
        intArray.getSegment().copyFrom(MemorySegment.ofBuffer(buffer));
        return intArray;
    }

    public static void initialize(IntArray array, int value) {
        for (int i = 0; i < array.getSize(); ++i) {
            array.set(i, value);
        }
    }

    public static IntArray concat(IntArray ... arrays) {
        int newSize = Arrays.stream(arrays).mapToInt(IntArray::getSize).sum();
        IntArray concatArray = new IntArray(newSize);
        long currentPositionBytes = 0L;
        for (IntArray array : arrays) {
            MemorySegment.copy(array.getSegment(), 0L, concatArray.getSegment(), currentPositionBytes, array.getNumBytesOfSegment());
            currentPositionBytes += array.getNumBytesOfSegment();
        }
        return concatArray;
    }

    public int[] toHeapArray() {
        int[] outputArray = new int[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            outputArray[i] = this.get(i);
        }
        return outputArray;
    }

    public void set(int index, int value) {
        this.segment.setAtIndex(index, value, this.baseIndex);
    }

    public void setF(int index, float value) {
        this.segment.setAtIndex(index, value, this.baseIndex);
    }

    public int get(int index) {
        return this.segment.getIntAtIndex(index, this.baseIndex);
    }

    public float getF(int index) {
        return this.segment.getFloatAtIndex(index, this.baseIndex);
    }

    @Override
    public void clear() {
        this.init(0);
    }

    @Override
    public int getElementSize() {
        return 4;
    }

    public void init(int value) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.segment.setAtIndex(i, value, this.baseIndex);
        }
    }

    @Override
    public int getSize() {
        return this.numberOfElements;
    }

    @Override
    public long getNumBytesOfSegmentWithHeader() {
        return this.segmentByteSize;
    }

    @Override
    public long getNumBytesOfSegment() {
        return this.segmentByteSize - TornadoNativeArray.ARRAY_HEADER;
    }

    @Override
    public MemorySegment getSegment() {
        return this.segment.getSegment().asSlice(TornadoNativeArray.ARRAY_HEADER);
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.segment.getSegment();
    }

    public IntArray slice(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > this.getSize()) {
            throw new IllegalArgumentException("Slice out of bounds");
        }
        long sliceOffsetInBytes = TornadoNativeArray.ARRAY_HEADER + (long)offset * 4L;
        long sliceByteLength = (long)length * 4L;
        MemorySegment sliceSegment = this.segment.getSegment().asSlice(sliceOffsetInBytes, sliceByteLength);
        IntArray slice = IntArray.fromSegment(sliceSegment);
        return slice;
    }
}

