/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.arrays;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.internal.annotations.SegmentElementSize;
import uk.ac.manchester.tornado.api.types.arrays.TornadoMemorySegment;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;

@SegmentElementSize(size=1)
public final class Int8Array
extends TornadoNativeArray {
    private static final int INT8_BYTES = 1;
    private TornadoMemorySegment segment;
    private int numberOfElements;
    private int arrayHeaderSize;
    private int baseIndex;
    private long segmentByteSize;

    public Int8Array(int numberOfElements) {
        this.numberOfElements = numberOfElements;
        this.arrayHeaderSize = (int)TornadoNativeArray.ARRAY_HEADER;
        this.baseIndex = this.arrayHeaderSize / 1;
        this.segmentByteSize = (long)numberOfElements * 1L + (long)this.arrayHeaderSize;
        this.segment = new TornadoMemorySegment(this.segmentByteSize, numberOfElements);
    }

    private Int8Array(MemorySegment existingSegment) {
        this.arrayHeaderSize = (int)TornadoNativeArray.ARRAY_HEADER;
        this.baseIndex = this.arrayHeaderSize / 1;
        long dataSize = existingSegment.byteSize() - (long)this.arrayHeaderSize;
        Int8Array.ensureMultipleOfElementSize(dataSize, 1L);
        this.numberOfElements = (int)(dataSize / 1L);
        this.segmentByteSize = existingSegment.byteSize();
        this.segment = new TornadoMemorySegment(existingSegment);
        this.segment.getSegment().setAtIndex(ValueLayout.JAVA_INT, 0L, this.numberOfElements);
    }

    public Int8Array(Int8Array ... arrays) {
        Int8Array.concat(arrays);
    }

    private static Int8Array createSegment(byte[] values) {
        Int8Array array = new Int8Array(values.length);
        for (int i = 0; i < values.length; ++i) {
            array.set(i, values[i]);
        }
        return array;
    }

    public static Int8Array fromArray(byte[] values) {
        return Int8Array.createSegment(values);
    }

    public static Int8Array fromElements(byte ... values) {
        return Int8Array.createSegment(values);
    }

    public static Int8Array fromSegment(MemorySegment segment) {
        int numElements = (int)segment.byteSize();
        Int8Array int8Array = new Int8Array(numElements);
        MemorySegment.copy(segment, 0L, int8Array.segment.getSegment(), int8Array.baseIndex, numElements);
        return int8Array;
    }

    public static Int8Array fromSegmentShallow(MemorySegment segment) {
        return new Int8Array(segment);
    }

    public static void initialize(Int8Array array, byte value) {
        for (int i = 0; i < array.getSize(); ++i) {
            array.set(i, value);
        }
    }

    public static Int8Array concat(Int8Array ... arrays) {
        int newSize = Arrays.stream(arrays).mapToInt(Int8Array::getSize).sum();
        Int8Array concatArray = new Int8Array(newSize);
        long currentPositionBytes = 0L;
        for (Int8Array array : arrays) {
            MemorySegment.copy(array.getSegment(), 0L, concatArray.getSegment(), currentPositionBytes, array.getNumBytesOfSegment());
            currentPositionBytes += array.getNumBytesOfSegment();
        }
        return concatArray;
    }

    public byte[] toHeapArray() {
        byte[] outputArray = new byte[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            outputArray[i] = this.get(i);
        }
        return outputArray;
    }

    public void set(int index, byte value) {
        this.segment.setAtIndex(index, value, this.baseIndex);
    }

    public byte get(int index) {
        return this.segment.getByteAtIndex(index, this.baseIndex);
    }

    @Override
    public void clear() {
        this.init((byte)0);
    }

    @Override
    public int getElementSize() {
        return 1;
    }

    public void init(byte value) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.segment.setAtIndex(i, value, this.baseIndex);
        }
    }

    @Override
    public int getSize() {
        return this.numberOfElements;
    }

    @Override
    public MemorySegment getSegment() {
        return this.segment.getSegment().asSlice(TornadoNativeArray.ARRAY_HEADER);
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.segment.getSegment();
    }

    @Override
    public long getNumBytesOfSegmentWithHeader() {
        return this.segmentByteSize;
    }

    @Override
    public long getNumBytesOfSegment() {
        return this.segmentByteSize - TornadoNativeArray.ARRAY_HEADER;
    }

    public Int8Array slice(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > this.getSize()) {
            throw new IllegalArgumentException("Slice out of bounds");
        }
        long sliceOffsetInBytes = TornadoNativeArray.ARRAY_HEADER + (long)offset;
        long sliceByteLength = length;
        MemorySegment sliceSegment = this.segment.getSegment().asSlice(sliceOffsetInBytes, sliceByteLength);
        Int8Array slice = Int8Array.fromSegment(sliceSegment);
        return slice;
    }
}

