/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.arrays;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.internal.annotations.SegmentElementSize;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.arrays.TornadoMemorySegment;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;

@SegmentElementSize(size=2)
public final class HalfFloatArray
extends TornadoNativeArray {
    private static final int HALF_FLOAT_BYTES = 2;
    private TornadoMemorySegment segment;
    private int numberOfElements;
    private int arrayHeaderSize;
    private int baseIndex;
    private long segmentByteSize;

    public HalfFloatArray(int numberOfElements) {
        this.numberOfElements = numberOfElements;
        this.arrayHeaderSize = (int)TornadoNativeArray.ARRAY_HEADER;
        this.baseIndex = this.arrayHeaderSize / 2;
        this.segmentByteSize = (long)numberOfElements * 2L + (long)this.arrayHeaderSize;
        this.segment = new TornadoMemorySegment(this.segmentByteSize, numberOfElements);
    }

    private HalfFloatArray(MemorySegment existingSegment) {
        this.arrayHeaderSize = (int)TornadoNativeArray.ARRAY_HEADER;
        this.baseIndex = this.arrayHeaderSize / 2;
        long dataSize = existingSegment.byteSize() - (long)this.arrayHeaderSize;
        HalfFloatArray.ensureMultipleOfElementSize(dataSize, 2L);
        this.numberOfElements = (int)(dataSize / 2L);
        this.segmentByteSize = existingSegment.byteSize();
        this.segment = new TornadoMemorySegment(existingSegment);
        this.segment.getSegment().setAtIndex(ValueLayout.JAVA_INT, 0L, this.numberOfElements);
    }

    public HalfFloatArray(HalfFloatArray ... arrays) {
        HalfFloatArray.concat(arrays);
    }

    private static HalfFloatArray createSegment(HalfFloat[] values) {
        HalfFloatArray array = new HalfFloatArray(values.length);
        for (int i = 0; i < values.length; ++i) {
            array.set(i, values[i]);
        }
        return array;
    }

    public static HalfFloatArray fromArray(HalfFloat[] values) {
        return HalfFloatArray.createSegment(values);
    }

    public static HalfFloatArray fromElements(HalfFloat ... values) {
        return HalfFloatArray.createSegment(values);
    }

    public static HalfFloatArray fromSegment(MemorySegment segment) {
        long byteSize = segment.byteSize();
        int numElements = (int)(byteSize / 2L);
        HalfFloatArray.ensureMultipleOfElementSize(byteSize, 2L);
        HalfFloatArray halfFloatArray = new HalfFloatArray(numElements);
        MemorySegment.copy(segment, 0L, halfFloatArray.segment.getSegment(), (long)halfFloatArray.baseIndex * 2L, byteSize);
        return halfFloatArray;
    }

    public static HalfFloatArray fromSegmentShallow(MemorySegment segment) {
        return new HalfFloatArray(segment);
    }

    public static void initialize(HalfFloatArray array, HalfFloat value) {
        for (int i = 0; i < array.getSize(); ++i) {
            array.set(i, value);
        }
    }

    public static HalfFloatArray concat(HalfFloatArray ... arrays) {
        int newSize = Arrays.stream(arrays).mapToInt(HalfFloatArray::getSize).sum();
        HalfFloatArray concatArray = new HalfFloatArray(newSize);
        long currentPositionBytes = 0L;
        for (HalfFloatArray array : arrays) {
            MemorySegment.copy(array.getSegment(), 0L, concatArray.getSegment(), currentPositionBytes, array.getNumBytesOfSegment());
            currentPositionBytes += array.getNumBytesOfSegment();
        }
        return concatArray;
    }

    public HalfFloat[] toHeapArray() {
        HalfFloat[] outputArray = new HalfFloat[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            outputArray[i] = this.get(i);
        }
        return outputArray;
    }

    public short[] toShortArray() {
        short[] outputArray = new short[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            outputArray[i] = this.get(i).getHalfFloatValue();
        }
        return outputArray;
    }

    public void set(int index, HalfFloat value) {
        this.segment.setAtIndex(index, value.getHalfFloatValue(), this.baseIndex);
    }

    public HalfFloat get(int index) {
        short halfFloatValue = this.segment.getShortAtIndex(index, this.baseIndex);
        return new HalfFloat(halfFloatValue);
    }

    @Override
    public void clear() {
        this.init(new HalfFloat(0.0f));
    }

    @Override
    public int getElementSize() {
        return 2;
    }

    public void init(HalfFloat value) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.segment.setAtIndex(i, value.getHalfFloatValue(), this.baseIndex);
        }
    }

    @Override
    public int getSize() {
        return this.numberOfElements;
    }

    @Override
    public MemorySegment getSegment() {
        return this.segment.getSegment().asSlice(TornadoNativeArray.ARRAY_HEADER);
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.segment.getSegment();
    }

    @Override
    public long getNumBytesOfSegmentWithHeader() {
        return this.segmentByteSize;
    }

    @Override
    public long getNumBytesOfSegment() {
        return this.segmentByteSize - TornadoNativeArray.ARRAY_HEADER;
    }

    public HalfFloatArray slice(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > this.getSize()) {
            throw new IllegalArgumentException("Slice out of bounds");
        }
        long sliceOffsetInBytes = TornadoNativeArray.ARRAY_HEADER + (long)offset * 2L;
        long sliceByteLength = (long)length * 2L;
        MemorySegment sliceSegment = this.segment.getSegment().asSlice(sliceOffsetInBytes, sliceByteLength);
        HalfFloatArray slice = HalfFloatArray.fromSegment(sliceSegment);
        return slice;
    }
}

