/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.arrays;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.FloatBuffer;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.internal.annotations.SegmentElementSize;
import uk.ac.manchester.tornado.api.types.arrays.TornadoMemorySegment;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;

@SegmentElementSize(size=4)
public final class FloatArray
extends TornadoNativeArray {
    private static final int FLOAT_BYTES = 4;
    private TornadoMemorySegment segment;
    private int numberOfElements;
    private int arrayHeaderSize;
    private int baseIndex;
    private long segmentByteSize;

    public FloatArray(int numberOfElements) {
        this.numberOfElements = numberOfElements;
        this.arrayHeaderSize = (int)TornadoNativeArray.ARRAY_HEADER;
        this.baseIndex = this.arrayHeaderSize / 4;
        this.segmentByteSize = (long)numberOfElements * 4L + (long)this.arrayHeaderSize;
        this.segment = new TornadoMemorySegment(this.segmentByteSize, numberOfElements);
    }

    private FloatArray(MemorySegment existingSegment) {
        this.arrayHeaderSize = (int)TornadoNativeArray.ARRAY_HEADER;
        this.baseIndex = this.arrayHeaderSize / 4;
        long dataSize = existingSegment.byteSize() - (long)this.arrayHeaderSize;
        FloatArray.ensureMultipleOfElementSize(dataSize, 4L);
        this.numberOfElements = (int)(dataSize / 4L);
        this.segmentByteSize = existingSegment.byteSize();
        this.segment = new TornadoMemorySegment(existingSegment);
        this.segment.getSegment().setAtIndex(ValueLayout.JAVA_INT, 0L, this.numberOfElements);
    }

    public FloatArray(FloatArray ... arrays) {
        FloatArray.concat(arrays);
    }

    private static FloatArray createSegment(float[] values) {
        FloatArray array = new FloatArray(values.length);
        for (int i = 0; i < values.length; ++i) {
            array.set(i, values[i]);
        }
        return array;
    }

    public static FloatArray fromArray(float[] values) {
        return FloatArray.createSegment(values);
    }

    public static FloatArray fromElements(float ... values) {
        return FloatArray.createSegment(values);
    }

    public static FloatArray fromSegment(MemorySegment segment) {
        long byteSize = segment.byteSize();
        int numElements = (int)(byteSize / 4L);
        FloatArray.ensureMultipleOfElementSize(byteSize, 4L);
        FloatArray floatArray = new FloatArray(numElements);
        MemorySegment.copy(segment, 0L, floatArray.segment.getSegment(), (long)floatArray.baseIndex * 4L, byteSize);
        return floatArray;
    }

    public static FloatArray fromSegmentShallow(MemorySegment segment) {
        return new FloatArray(segment);
    }

    public static FloatArray fromFloatBuffer(FloatBuffer buffer) {
        int numElements = buffer.remaining();
        FloatArray floatArray = new FloatArray(numElements);
        floatArray.getSegment().copyFrom(MemorySegment.ofBuffer(buffer));
        return floatArray;
    }

    public static void initialize(FloatArray array, float value) {
        for (int i = 0; i < array.getSize(); ++i) {
            array.set(i, value);
        }
    }

    public static FloatArray concat(FloatArray ... arrays) {
        int newSize = Arrays.stream(arrays).mapToInt(FloatArray::getSize).sum();
        FloatArray concatArray = new FloatArray(newSize);
        long currentPositionBytes = 0L;
        for (FloatArray array : arrays) {
            MemorySegment.copy(array.getSegment(), 0L, concatArray.getSegment(), currentPositionBytes, array.getNumBytesOfSegment());
            currentPositionBytes += array.getNumBytesOfSegment();
        }
        return concatArray;
    }

    public float[] toHeapArray() {
        float[] outputArray = new float[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            outputArray[i] = this.get(i);
        }
        return outputArray;
    }

    public void set(int index, float value) {
        this.segment.setAtIndex(index, value, this.baseIndex);
    }

    public float get(int index) {
        return this.segment.getFloatAtIndex(index, this.baseIndex);
    }

    @Override
    public void clear() {
        this.init(0.0f);
    }

    @Override
    public int getElementSize() {
        return 4;
    }

    public void init(float value) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.segment.setAtIndex(i, value, this.baseIndex);
        }
    }

    @Override
    public int getSize() {
        return this.numberOfElements;
    }

    @Override
    public MemorySegment getSegment() {
        return this.segment.getSegment().asSlice(TornadoNativeArray.ARRAY_HEADER);
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.segment.getSegment();
    }

    @Override
    public long getNumBytesOfSegmentWithHeader() {
        return this.segmentByteSize;
    }

    @Override
    public long getNumBytesOfSegment() {
        return this.segmentByteSize - TornadoNativeArray.ARRAY_HEADER;
    }

    public FloatArray slice(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > this.getSize()) {
            throw new IllegalArgumentException("Slice out of bounds");
        }
        long sliceOffsetInBytes = TornadoNativeArray.ARRAY_HEADER + (long)offset * 4L;
        long sliceByteLength = (long)length * 4L;
        MemorySegment sliceSegment = this.segment.getSegment().asSlice(sliceOffsetInBytes, sliceByteLength);
        FloatArray slice = FloatArray.fromSegment(sliceSegment);
        return slice;
    }
}

