/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.arrays;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.DoubleBuffer;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.internal.annotations.SegmentElementSize;
import uk.ac.manchester.tornado.api.types.arrays.TornadoMemorySegment;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;

@SegmentElementSize(size=8)
public final class DoubleArray
extends TornadoNativeArray {
    private static final int DOUBLE_BYTES = 8;
    private TornadoMemorySegment segment;
    private int numberOfElements;
    private int arrayHeaderSize;
    private int baseIndex;
    private long segmentByteSize;

    public DoubleArray(int numberOfElements) {
        this.numberOfElements = numberOfElements;
        this.arrayHeaderSize = (int)TornadoNativeArray.ARRAY_HEADER;
        assert (this.arrayHeaderSize >= 8);
        this.baseIndex = this.arrayHeaderSize / 8;
        this.segmentByteSize = (long)numberOfElements * 8L + (long)this.arrayHeaderSize;
        this.segment = new TornadoMemorySegment(this.segmentByteSize, numberOfElements);
    }

    private DoubleArray(MemorySegment existingSegment) {
        this.arrayHeaderSize = (int)TornadoNativeArray.ARRAY_HEADER;
        this.baseIndex = this.arrayHeaderSize / 8;
        long dataSize = existingSegment.byteSize() - (long)this.arrayHeaderSize;
        DoubleArray.ensureMultipleOfElementSize(dataSize, 8L);
        this.numberOfElements = (int)(dataSize / 8L);
        this.segmentByteSize = existingSegment.byteSize();
        this.segment = new TornadoMemorySegment(existingSegment);
        this.segment.getSegment().setAtIndex(ValueLayout.JAVA_INT, 0L, this.numberOfElements);
    }

    public DoubleArray(DoubleArray ... arrays) {
        DoubleArray.concat(arrays);
    }

    private static DoubleArray createSegment(double[] values) {
        DoubleArray array = new DoubleArray(values.length);
        for (int i = 0; i < values.length; ++i) {
            array.set(i, values[i]);
        }
        return array;
    }

    public static DoubleArray fromArray(double[] values) {
        return DoubleArray.createSegment(values);
    }

    public static DoubleArray fromElements(double ... values) {
        return DoubleArray.createSegment(values);
    }

    public static DoubleArray fromSegment(MemorySegment segment) {
        long byteSize = segment.byteSize();
        int numElements = (int)(byteSize / 8L);
        DoubleArray.ensureMultipleOfElementSize(byteSize, 8L);
        DoubleArray doubleArray = new DoubleArray(numElements);
        MemorySegment.copy(segment, 0L, doubleArray.segment.getSegment(), (long)doubleArray.baseIndex * 8L, byteSize);
        return doubleArray;
    }

    public static DoubleArray fromSegmentShallow(MemorySegment segment) {
        return new DoubleArray(segment);
    }

    public static DoubleArray fromDoubleBuffer(DoubleBuffer buffer) {
        int numElements = buffer.remaining();
        DoubleArray doubleArray = new DoubleArray(numElements);
        doubleArray.getSegment().copyFrom(MemorySegment.ofBuffer(buffer));
        return doubleArray;
    }

    public static void initialize(DoubleArray array, double value) {
        for (int i = 0; i < array.getSize(); ++i) {
            array.set(i, value);
        }
    }

    public static DoubleArray concat(DoubleArray ... arrays) {
        int newSize = Arrays.stream(arrays).mapToInt(DoubleArray::getSize).sum();
        DoubleArray concatArray = new DoubleArray(newSize);
        long currentPositionBytes = 0L;
        for (DoubleArray array : arrays) {
            MemorySegment.copy(array.getSegment(), 0L, concatArray.getSegment(), currentPositionBytes, array.getNumBytesOfSegment());
            currentPositionBytes += array.getNumBytesOfSegment();
        }
        return concatArray;
    }

    public double[] toHeapArray() {
        double[] outputArray = new double[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            outputArray[i] = this.get(i);
        }
        return outputArray;
    }

    public void set(int index, double value) {
        this.segment.setAtIndex(index, value, this.baseIndex);
    }

    public double get(int index) {
        return this.segment.getDoubleAtIndex(index, this.baseIndex);
    }

    @Override
    public void clear() {
        this.init(0.0);
    }

    @Override
    public int getElementSize() {
        return 8;
    }

    public void init(double value) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.segment.setAtIndex(i, value, this.baseIndex);
        }
    }

    @Override
    public int getSize() {
        return this.numberOfElements;
    }

    @Override
    public MemorySegment getSegment() {
        return this.segment.getSegment().asSlice(TornadoNativeArray.ARRAY_HEADER);
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.segment.getSegment();
    }

    @Override
    public long getNumBytesOfSegmentWithHeader() {
        return this.segmentByteSize;
    }

    @Override
    public long getNumBytesOfSegment() {
        return this.segmentByteSize - TornadoNativeArray.ARRAY_HEADER;
    }

    public DoubleArray slice(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > this.getSize()) {
            throw new IllegalArgumentException("Slice out of bounds");
        }
        long sliceOffsetInBytes = TornadoNativeArray.ARRAY_HEADER + (long)offset * 8L;
        long sliceByteLength = (long)length * 8L;
        MemorySegment sliceSegment = this.segment.getSegment().asSlice(sliceOffsetInBytes, sliceByteLength);
        DoubleArray slice = DoubleArray.fromSegment(sliceSegment);
        return slice;
    }
}

