/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.arrays;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.CharBuffer;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.internal.annotations.SegmentElementSize;
import uk.ac.manchester.tornado.api.types.arrays.TornadoMemorySegment;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;

@SegmentElementSize(size=2)
public final class CharArray
extends TornadoNativeArray {
    private static final int CHAR_BYTES = 2;
    private TornadoMemorySegment segment;
    private int numberOfElements;
    private int arrayHeaderSize;
    private int baseIndex;
    private long segmentByteSize;

    public CharArray(int numberOfElements) {
        this.numberOfElements = numberOfElements;
        this.arrayHeaderSize = (int)TornadoNativeArray.ARRAY_HEADER;
        this.baseIndex = this.arrayHeaderSize / 2;
        this.segmentByteSize = (long)numberOfElements * 2L + (long)this.arrayHeaderSize;
        this.segment = new TornadoMemorySegment(this.segmentByteSize, numberOfElements);
    }

    private CharArray(MemorySegment existingSegment) {
        this.arrayHeaderSize = (int)TornadoNativeArray.ARRAY_HEADER;
        this.baseIndex = this.arrayHeaderSize / 2;
        long dataSize = existingSegment.byteSize() - (long)this.arrayHeaderSize;
        CharArray.ensureMultipleOfElementSize(dataSize, 2L);
        this.numberOfElements = (int)(dataSize / 2L);
        this.segmentByteSize = existingSegment.byteSize();
        this.segment = new TornadoMemorySegment(existingSegment);
        this.segment.getSegment().setAtIndex(ValueLayout.JAVA_INT, 0L, this.numberOfElements);
    }

    public CharArray(CharArray ... arrays) {
        CharArray.concat(arrays);
    }

    private static CharArray createSegment(char[] values) {
        CharArray array = new CharArray(values.length);
        for (int i = 0; i < values.length; ++i) {
            array.set(i, values[i]);
        }
        return array;
    }

    public static CharArray fromArray(char[] values) {
        return CharArray.createSegment(values);
    }

    public static CharArray fromElements(char ... values) {
        return CharArray.createSegment(values);
    }

    public static CharArray fromSegment(MemorySegment segment) {
        long byteSize = segment.byteSize();
        int numElements = (int)(byteSize / 2L);
        CharArray.ensureMultipleOfElementSize(byteSize, 2L);
        CharArray charArray = new CharArray(numElements);
        MemorySegment.copy(segment, 0L, charArray.segment.getSegment(), (long)charArray.baseIndex * 2L, byteSize);
        return charArray;
    }

    public static CharArray fromSegmentShallow(MemorySegment segment) {
        return new CharArray(segment);
    }

    public static CharArray fromCharBuffer(CharBuffer buffer) {
        int numElements = buffer.remaining();
        CharArray charArray = new CharArray(numElements);
        charArray.getSegment().copyFrom(MemorySegment.ofBuffer(buffer));
        return charArray;
    }

    public static void initialize(CharArray array, char value) {
        for (int i = 0; i < array.getSize(); ++i) {
            array.set(i, value);
        }
    }

    public static CharArray concat(CharArray ... arrays) {
        int newSize = Arrays.stream(arrays).mapToInt(CharArray::getSize).sum();
        CharArray concatArray = new CharArray(newSize);
        long currentPositionBytes = 0L;
        for (CharArray array : arrays) {
            MemorySegment.copy(array.getSegment(), 0L, concatArray.getSegment(), currentPositionBytes, array.getNumBytesOfSegment());
            currentPositionBytes += array.getNumBytesOfSegment();
        }
        return concatArray;
    }

    @Override
    public void clear() {
        this.init('\u0000');
    }

    @Override
    public int getElementSize() {
        return 2;
    }

    public char[] toHeapArray() {
        char[] outputArray = new char[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            outputArray[i] = this.get(i);
        }
        return outputArray;
    }

    public void set(int index, char value) {
        this.segment.setAtIndex(index, value, this.baseIndex);
    }

    public char get(int index) {
        return this.segment.getCharAtIndex(index, this.baseIndex);
    }

    public void init(char value) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.segment.setAtIndex(i, value, this.baseIndex);
        }
    }

    @Override
    public int getSize() {
        return this.numberOfElements;
    }

    @Override
    public MemorySegment getSegment() {
        return this.segment.getSegment().asSlice(TornadoNativeArray.ARRAY_HEADER);
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.segment.getSegment();
    }

    @Override
    public long getNumBytesOfSegmentWithHeader() {
        return this.segmentByteSize;
    }

    @Override
    public long getNumBytesOfSegment() {
        return this.segmentByteSize - TornadoNativeArray.ARRAY_HEADER;
    }

    public CharArray slice(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > this.getSize()) {
            throw new IllegalArgumentException("Slice out of bounds");
        }
        long sliceOffsetInBytes = TornadoNativeArray.ARRAY_HEADER + (long)offset * 2L;
        long sliceByteLength = (long)length * 2L;
        MemorySegment sliceSegment = this.segment.getSegment().asSlice(sliceOffsetInBytes, sliceByteLength);
        CharArray slice = CharArray.fromSegment(sliceSegment);
        return slice;
    }
}

