/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.profiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.EnumSet;

public class JSonWriter<T extends JSonWriter> {
    private StringBuilder sb;
    private int scope = 0;
    private boolean compactMode = false;
    public static final long EPOCH_US = System.nanoTime() / 1000L;
    private State currentState = State.NONE;

    JSonWriter() {
        this.sb = new StringBuilder();
    }

    protected T incScope() {
        ++this.scope;
        return (T)this;
    }

    protected T decScope() {
        --this.scope;
        return (T)this;
    }

    protected T state(State newState) {
        this.currentState = newState;
        return (T)this;
    }

    protected T append(String s) {
        this.sb.append(s);
        return (T)this;
    }

    protected T append(StringBuilder sb) {
        return this.append(sb.toString());
    }

    protected T append(JSonWriter json) {
        return this.append(json.toString());
    }

    protected T append(long value) {
        this.append(Long.toString(value));
        return (T)this;
    }

    protected T append(int value) {
        this.append(Integer.toString(value));
        return (T)this;
    }

    protected T append(float value) {
        this.append(Float.toString(value));
        return (T)this;
    }

    protected T append(double value) {
        this.append(Double.toString(value));
        return (T)this;
    }

    protected T quote(String value) {
        return ((JSonWriter)this.append("\"" + value + "\"")).state(State.AFTER_VALUE);
    }

    protected T colon() {
        return ((JSonWriter)this.append(":")).state(State.AFTER_COLON);
    }

    protected T obrace() {
        return ((JSonWriter)((JSonWriter)((JSonWriter)((JSonWriter)this.commaIfNeeded()).append("{")).state(State.AFTER_OBRACE)).incScope()).newlineIfNeeded();
    }

    protected T cbrace() {
        this.decScope();
        if (this.currentState == State.AFTER_VALUE) {
            this.newline();
        }
        return ((JSonWriter)((JSonWriter)this.append("}")).state(State.AFTER_CBRACE)).newlineIfNeeded();
    }

    protected T osqbrace() {
        return ((JSonWriter)((JSonWriter)((JSonWriter)((JSonWriter)this.commaIfNeeded()).append("[")).state(State.AFTER_OBRACE)).incScope()).newlineIfNeeded();
    }

    protected T csqbrace() {
        this.decScope();
        if (this.currentState == State.AFTER_VALUE) {
            this.newline();
        }
        return ((JSonWriter)((JSonWriter)this.append("]")).state(State.AFTER_CBRACE)).newlineIfNeeded();
    }

    T arrayStart(String k) {
        return ((JSonWriter)this.key(k)).osqbrace();
    }

    T arrayEnd() {
        return this.csqbrace();
    }

    T objectStart(String k) {
        return ((JSonWriter)this.key(k)).obrace();
    }

    T objectStart() {
        return this.obrace();
    }

    T objectEnd() {
        return this.cbrace();
    }

    T object(ContentWriter w) {
        this.objectStart();
        if (w != null) {
            w.write();
        }
        return this.objectEnd();
    }

    T object(String k, ContentWriter w) {
        this.objectStart(k);
        if (w != null) {
            w.write();
        }
        return this.objectEnd();
    }

    T array(String k, ContentWriter w) {
        this.arrayStart(k);
        if (w != null) {
            w.write();
        }
        return this.arrayEnd();
    }

    protected T compact() {
        this.compactMode = true;
        return (T)this;
    }

    protected T nonCompact() {
        this.compactMode = false;
        return (T)this;
    }

    protected T newline() {
        this.append("\n");
        for (int i = 0; i < this.scope; ++i) {
            this.append(" ");
        }
        return (T)this;
    }

    protected T newlineIfNeeded() {
        if (!this.compactMode && this.currentState.needsNewLine()) {
            this.newline();
        }
        return (T)this;
    }

    protected T commaIfNeeded() {
        if (this.currentState.needsComma()) {
            ((JSonWriter)((JSonWriter)this.append(",")).state(State.AFTER_COMMA)).newlineIfNeeded();
        }
        return (T)this;
    }

    protected T key(String k) {
        return ((JSonWriter)((JSonWriter)((JSonWriter)this.commaIfNeeded()).quote(k)).colon()).state(State.AFTER_COLON);
    }

    T kv(String k, String value) {
        return (T)(value != null ? ((JSonWriter)((JSonWriter)this.key(k)).quote(value)).state(State.AFTER_VALUE) : this);
    }

    T kv(String k, long value) {
        return ((JSonWriter)((JSonWriter)this.key(k)).append(value)).state(State.AFTER_VALUE);
    }

    T kv(String k, int value) {
        return ((JSonWriter)((JSonWriter)this.key(k)).append(value)).state(State.AFTER_VALUE);
    }

    T kv(String k, float value) {
        return ((JSonWriter)((JSonWriter)this.key(k)).append(value)).state(State.AFTER_VALUE);
    }

    T kv(String k, boolean value) {
        return ((JSonWriter)((JSonWriter)this.key(k)).append(value ? "true" : "false")).state(State.AFTER_VALUE);
    }

    T us(String k, long valueUs) {
        return this.kv(k, valueUs - EPOCH_US);
    }

    T ns(String k, long valueNs) {
        return this.us(k, valueNs / 1000L);
    }

    T ms(String k, long valueMs) {
        return this.us(k, valueMs * 1000L);
    }

    T usd(String k, long valueUs) {
        return this.kv(k, valueUs);
    }

    T nsd(String k, long valueNs) {
        return this.usd(k, valueNs / 1000L);
    }

    T msd(String k, long valueMs) {
        return this.usd(k, valueMs * 1000L);
    }

    public String toString() {
        return this.sb.toString();
    }

    void write(File file) {
        try {
            OutputStreamWriter o = new OutputStreamWriter(new FileOutputStream(file));
            o.append(this.toString());
            o.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static enum State {
        NONE,
        AFTER_COMMA,
        AFTER_OBRACE,
        AFTER_CBRACE,
        AFTER_COLON,
        AFTER_VALUE;

        private static final EnumSet<State> needsComma;
        private static final EnumSet<State> needsNewline;

        boolean needsComma() {
            return needsComma.contains((Object)this);
        }

        boolean needsNewLine() {
            return needsNewline.contains((Object)this);
        }

        static {
            needsComma = EnumSet.of(AFTER_CBRACE, AFTER_VALUE);
            needsNewline = EnumSet.of(AFTER_CBRACE, AFTER_COMMA, AFTER_OBRACE);
        }
    }

    static interface ContentWriter {
        public void write();
    }
}

