/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import uk.ac.manchester.tornado.api.DataRange;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.runtime.ExecutorFrame;

class TornadoExecutor {
    private final List<ImmutableTaskGraph> immutableTaskGraphList = new ArrayList<ImmutableTaskGraph>();
    private List<ImmutableTaskGraph> subgraphList;

    TornadoExecutor(ImmutableTaskGraph ... immutableTaskGraphs) {
        Collections.addAll(this.immutableTaskGraphList, immutableTaskGraphs);
    }

    void execute(ExecutorFrame executionPackage) {
        this.immutableTaskGraphList.forEach(immutableTaskGraph -> immutableTaskGraph.execute(executionPackage));
    }

    boolean withGridScheduler(GridScheduler gridScheduler) {
        boolean checkGridRegistered = false;
        for (ImmutableTaskGraph immutableTaskGraph : this.immutableTaskGraphList) {
            immutableTaskGraph.withGridScheduler(gridScheduler);
            checkGridRegistered |= immutableTaskGraph.isGridRegistered();
        }
        return checkGridRegistered;
    }

    void updateLastExecutedTaskGraph() {
        ImmutableTaskGraph last = this.immutableTaskGraphList.getLast();
        this.immutableTaskGraphList.forEach(immutableTaskGraph -> immutableTaskGraph.setLastExecutedTaskGraph(this.immutableTaskGraphList.getLast()));
        if (this.subgraphList != null) {
            for (ImmutableTaskGraph immutableTaskGraph2 : this.subgraphList) {
                immutableTaskGraph2.setLastExecutedTaskGraph(last);
            }
        }
    }

    void withPreCompilation(ExecutorFrame executorFrame) {
        this.immutableTaskGraphList.forEach(immutableTaskGraph -> immutableTaskGraph.withPreCompilation(executorFrame));
    }

    void withBatch(String batchSize) {
        this.immutableTaskGraphList.forEach(immutableTaskGraph -> immutableTaskGraph.withBatch(batchSize));
    }

    void withMemoryLimit(String memoryLimit) {
        this.immutableTaskGraphList.forEach(immutableTaskGraph -> immutableTaskGraph.withMemoryLimit(memoryLimit));
    }

    public void withoutMemoryLimit() {
        this.immutableTaskGraphList.forEach(ImmutableTaskGraph::withoutMemoryLimit);
    }

    void setDevice(TornadoDevice device) {
        this.immutableTaskGraphList.forEach(immutableTaskGraph -> immutableTaskGraph.withDevice(device));
    }

    void setDevice(String taskName, TornadoDevice device) {
        this.immutableTaskGraphList.forEach(immutableTaskGraph -> immutableTaskGraph.withDevice(taskName, device));
    }

    void withConcurrentDevices() {
        this.immutableTaskGraphList.forEach(ImmutableTaskGraph::withConcurrentDevices);
    }

    void withoutConcurrentDevices() {
        this.immutableTaskGraphList.forEach(ImmutableTaskGraph::withoutConcurrentDevices);
    }

    void freeDeviceMemory() {
        this.immutableTaskGraphList.forEach(ImmutableTaskGraph::freeDeviceMemory);
    }

    void transferToHost(Object ... objects) {
        this.immutableTaskGraphList.forEach(immutableTaskGraph -> immutableTaskGraph.transferToHost(objects));
    }

    void partialTransferToHost(DataRange dataRange) {
        dataRange.materialize();
        this.immutableTaskGraphList.forEach(immutableTaskGraph -> immutableTaskGraph.transferToHost((Object)dataRange.getArray(), dataRange.getOffset(), dataRange.getPartialSize()));
    }

    boolean isFinished() {
        boolean result = true;
        for (ImmutableTaskGraph immutableTaskGraph : this.immutableTaskGraphList) {
            result &= immutableTaskGraph.isFinished();
        }
        return result;
    }

    void resetDevice() {
        this.immutableTaskGraphList.forEach(ImmutableTaskGraph::resetDevice);
    }

    long getTotalTime() {
        return this.immutableTaskGraphList.stream().map(ImmutableTaskGraph::getTotalTime).mapToLong(Long::longValue).sum();
    }

    long getCompileTime() {
        return this.immutableTaskGraphList.stream().map(ImmutableTaskGraph::getCompileTime).mapToLong(Long::longValue).sum();
    }

    long getTornadoCompilerTime() {
        return this.immutableTaskGraphList.stream().map(ImmutableTaskGraph::getTornadoCompilerTime).mapToLong(Long::longValue).sum();
    }

    long getDriverInstallTime() {
        return this.immutableTaskGraphList.stream().map(ImmutableTaskGraph::getDriverInstallTime).mapToLong(Long::longValue).sum();
    }

    long getDataTransfersTime() {
        return this.immutableTaskGraphList.stream().map(ImmutableTaskGraph::getDataTransfersTime).mapToLong(Long::longValue).sum();
    }

    long getDeviceWriteTime() {
        return this.immutableTaskGraphList.stream().map(ImmutableTaskGraph::getDeviceWriteTime).mapToLong(Long::longValue).sum();
    }

    long getDeviceReadTime() {
        return this.immutableTaskGraphList.stream().map(ImmutableTaskGraph::getDeviceReadTime).mapToLong(Long::longValue).sum();
    }

    long getDataTransferDispatchTime() {
        return this.immutableTaskGraphList.stream().map(ImmutableTaskGraph::getDataTransferDispatchTime).mapToLong(Long::longValue).sum();
    }

    long getKernelDispatchTime() {
        return this.immutableTaskGraphList.stream().map(ImmutableTaskGraph::getKernelDispatchTime).mapToLong(Long::longValue).sum();
    }

    long getDeviceKernelTime() {
        return this.immutableTaskGraphList.stream().map(ImmutableTaskGraph::getDeviceKernelTime).mapToLong(Long::longValue).sum();
    }

    long getTotalBytesCopyIn() {
        return this.immutableTaskGraphList.stream().map(ImmutableTaskGraph::getTotalBytesCopyIn).mapToLong(Long::longValue).sum();
    }

    long getTotalBytesCopyOut() {
        return this.immutableTaskGraphList.stream().map(ImmutableTaskGraph::getTotalBytesCopyOut).mapToLong(Long::longValue).sum();
    }

    String getProfileLog() {
        return this.immutableTaskGraphList.stream().map(ImmutableTaskGraph::getProfileLog).collect(Collectors.joining());
    }

    void dumpProfiles() {
        this.immutableTaskGraphList.forEach(ImmutableTaskGraph::dumpProfiles);
    }

    void clearProfiles() {
        this.immutableTaskGraphList.forEach(ImmutableTaskGraph::clearProfiles);
    }

    void withDefaultScheduler() {
        this.immutableTaskGraphList.forEach(immutableTaskGraph -> immutableTaskGraph.withDefaultScheduler(true));
    }

    TornadoDevice getDevice(int immutableTaskGraphIndex) {
        if (this.immutableTaskGraphList.size() < immutableTaskGraphIndex) {
            throw new TornadoRuntimeException("TaskGraph index #" + immutableTaskGraphIndex + " does not exist in current executor");
        }
        return this.immutableTaskGraphList.get(immutableTaskGraphIndex).getDevice();
    }

    void withThreadInfo() {
        this.immutableTaskGraphList.forEach(ImmutableTaskGraph::withThreadInfo);
    }

    List<Object> getOutputs() {
        ArrayList<Object> outputs = new ArrayList<Object>();
        this.immutableTaskGraphList.forEach(immutableTaskGraph -> outputs.addAll(immutableTaskGraph.getOutputs()));
        return outputs;
    }

    void withoutThreadInfo() {
        this.immutableTaskGraphList.forEach(ImmutableTaskGraph::withoutThreadInfo);
    }

    void withPrintKernel() {
        this.immutableTaskGraphList.forEach(ImmutableTaskGraph::withPrintKernel);
    }

    void withoutPrintKernel() {
        this.immutableTaskGraphList.forEach(ImmutableTaskGraph::withoutPrintKernel);
    }

    void withCompilerFlags(TornadoVMBackendType backendType, String compilerFlags) {
        this.immutableTaskGraphList.forEach(immutableTaskGraph -> immutableTaskGraph.withCompilerFlags(backendType, compilerFlags));
    }

    long getTotalBytesTransferred() {
        return this.immutableTaskGraphList.stream().mapToLong(ImmutableTaskGraph::getTotalBytesTransferred).sum();
    }

    long getTotalDeviceMemoryUsage() {
        return this.immutableTaskGraphList.stream().mapToLong(ImmutableTaskGraph::getTotalDeviceMemoryUsage).sum();
    }

    long getCurrentDeviceMemoryUsage() {
        return this.immutableTaskGraphList.stream().mapToLong(ImmutableTaskGraph::getCurrentDeviceMemoryUsage).sum();
    }

    void selectGraph(int graphIndex) {
        if (this.subgraphList == null) {
            this.subgraphList = new ArrayList<ImmutableTaskGraph>();
            this.immutableTaskGraphList.forEach(g -> Collections.addAll(this.subgraphList, g));
        }
        this.processPersistentStates(graphIndex);
        this.immutableTaskGraphList.clear();
        Collections.addAll(this.immutableTaskGraphList, this.subgraphList.get(graphIndex));
    }

    private void processPersistentStates(int graphIndex) {
        if (graphIndex < 0 || graphIndex >= this.subgraphList.size()) {
            throw new TornadoRuntimeException("Error: graphIndex out of bounds: " + graphIndex);
        }
        ImmutableTaskGraph selectedGraph = this.subgraphList.get(graphIndex);
        this.immutableTaskGraphList.clear();
        Collections.addAll(this.immutableTaskGraphList, selectedGraph);
    }

    private ImmutableTaskGraph getGraph(int graphIndex) {
        if (graphIndex < this.immutableTaskGraphList.size()) {
            return this.immutableTaskGraphList.get(graphIndex);
        }
        throw new TornadoRuntimeException("TaskGraph index #" + graphIndex + " does not exist in current executor");
    }

    private ImmutableTaskGraph getGraphByName(String uniqueName) {
        for (ImmutableTaskGraph immutableTaskGraph : this.immutableTaskGraphList) {
            if (!immutableTaskGraph.getTaskGraph().getTaskGraphName().equals(uniqueName)) continue;
            return immutableTaskGraph;
        }
        throw new TornadoRuntimeException("TaskGraph with name " + uniqueName + " does not exist in current executor");
    }

    void selectAll() {
        if (this.subgraphList == null) {
            return;
        }
        this.immutableTaskGraphList.clear();
        this.subgraphList.forEach(g -> Collections.addAll(this.immutableTaskGraphList, g));
        this.subgraphList = null;
    }

    void mapOnDeviceMemoryRegion(Object destArray, Object srcArray, long offset, int fromGraphIndex, int toGraphIndex) {
        this.selectAll();
        if (this.immutableTaskGraphList.size() < 2) {
            throw new TornadoRuntimeException("MapOnDeviceMemoryRegion needs at least two task graphs");
        }
        if (this.immutableTaskGraphList.size() < fromGraphIndex) {
            throw new TornadoRuntimeException("TaskGraph index #" + fromGraphIndex + " does not exist in current executor");
        }
        if (this.immutableTaskGraphList.size() < toGraphIndex) {
            throw new TornadoRuntimeException("TaskGraph index #" + toGraphIndex + " does not exist in current executor");
        }
        ImmutableTaskGraph taskGraphSrc = this.getGraph(fromGraphIndex);
        ImmutableTaskGraph taskGraphDest = this.getGraph(toGraphIndex);
        taskGraphDest.mapOnDeviceMemoryRegion(destArray, srcArray, offset, taskGraphSrc);
    }

    boolean checkAllTaskGraphsForGridScheduler() {
        if (this.subgraphList == null) {
            return false;
        }
        for (ImmutableTaskGraph immutableTaskGraph : this.subgraphList) {
            if (!immutableTaskGraph.isGridRegistered()) continue;
            return true;
        }
        return false;
    }

    public void withWarmUpTime(long milliseconds, ExecutorFrame executorFrame) throws InterruptedException {
        AtomicBoolean run = new AtomicBoolean(true);
        Thread warmUpThread = new Thread(() -> {
            while (run.get()) {
                this.runForWarmUp(executorFrame);
            }
        });
        Thread controllerThread = new Thread(() -> {
            try {
                Thread.sleep(milliseconds);
            }
            catch (InterruptedException e) {
                throw new TornadoRuntimeException(e);
            }
            run.set(false);
        });
        warmUpThread.start();
        controllerThread.start();
        warmUpThread.join();
        controllerThread.join();
    }

    private void runForWarmUp(ExecutorFrame executorFrame) {
        this.immutableTaskGraphList.forEach(immutableTaskGraph -> {
            immutableTaskGraph.execute(executorFrame);
            ImmutableTaskGraph last = this.immutableTaskGraphList.getLast();
            this.immutableTaskGraphList.forEach(itg -> itg.setLastExecutedTaskGraph(last));
        });
    }

    public void withWarmUpIterations(int iterations, ExecutorFrame executorFrame) {
        IntStream.range(0, iterations).forEach(iteration -> this.runForWarmUp(executorFrame));
    }
}

