/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import uk.ac.manchester.tornado.api.ExecutionPlanType;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoDeviceMap;
import uk.ac.manchester.tornado.api.TornadoExecutionResult;
import uk.ac.manchester.tornado.api.TornadoExecutor;
import uk.ac.manchester.tornado.api.TornadoProfilerResult;
import uk.ac.manchester.tornado.api.TornadoTaskGraphInterface;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.enums.ProfilerMode;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.plan.types.OffConcurrentDevices;
import uk.ac.manchester.tornado.api.plan.types.OffMemoryLimit;
import uk.ac.manchester.tornado.api.plan.types.OffPrintKernel;
import uk.ac.manchester.tornado.api.plan.types.OffProfiler;
import uk.ac.manchester.tornado.api.plan.types.OffThreadInfo;
import uk.ac.manchester.tornado.api.plan.types.WithAllGraphs;
import uk.ac.manchester.tornado.api.plan.types.WithBatch;
import uk.ac.manchester.tornado.api.plan.types.WithClearProfiles;
import uk.ac.manchester.tornado.api.plan.types.WithCompilerFlags;
import uk.ac.manchester.tornado.api.plan.types.WithConcurrentDevices;
import uk.ac.manchester.tornado.api.plan.types.WithDefaultScheduler;
import uk.ac.manchester.tornado.api.plan.types.WithDevice;
import uk.ac.manchester.tornado.api.plan.types.WithFreeDeviceMemory;
import uk.ac.manchester.tornado.api.plan.types.WithGraph;
import uk.ac.manchester.tornado.api.plan.types.WithGridScheduler;
import uk.ac.manchester.tornado.api.plan.types.WithMemoryLimit;
import uk.ac.manchester.tornado.api.plan.types.WithPreCompilation;
import uk.ac.manchester.tornado.api.plan.types.WithPrintKernel;
import uk.ac.manchester.tornado.api.plan.types.WithProfiler;
import uk.ac.manchester.tornado.api.plan.types.WithResetDevice;
import uk.ac.manchester.tornado.api.plan.types.WithThreadInfo;
import uk.ac.manchester.tornado.api.plan.types.WithWarmUpIterations;
import uk.ac.manchester.tornado.api.plan.types.WithWarmUpTime;
import uk.ac.manchester.tornado.api.runtime.ExecutorFrame;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;

public sealed class TornadoExecutionPlan
implements AutoCloseable
permits ExecutionPlanType {
    public static TornadoDevice DEFAULT_DEVICE = TornadoRuntimeProvider.getTornadoRuntime().getDefaultDevice();
    private static final AtomicLong globalExecutionPlanCounter = new AtomicLong(0L);
    protected TornadoExecutor tornadoExecutor;
    protected ExecutorFrame executionFrame;
    protected TornadoExecutionPlan rootNode;
    protected TornadoExecutionPlan childLink;
    protected TornadoExecutionPlan parentLink;
    protected List<TornadoExecutionResult> planResults;

    public TornadoExecutionPlan(ImmutableTaskGraph ... immutableTaskGraphs) {
        this.tornadoExecutor = new TornadoExecutor(immutableTaskGraphs);
        long id = globalExecutionPlanCounter.incrementAndGet();
        this.executionFrame = new ExecutorFrame(id);
        this.updateAccess(immutableTaskGraphs);
        this.rootNode = this;
        this.planResults = new ArrayList<TornadoExecutionResult>();
    }

    private void updateAccess(ImmutableTaskGraph ... immutableTaskGraphs) {
        if (immutableTaskGraphs.length > 1) {
            for (ImmutableTaskGraph immutableTaskGraph : immutableTaskGraphs) {
                TaskGraph taskGraph = immutableTaskGraph.getTaskGraph();
                TornadoTaskGraphInterface taskGraphImpl = taskGraph.getTaskGraphImpl();
                taskGraphImpl.updateObjectAccess();
            }
        }
    }

    public static TornadoDevice getDevice(int driverIndex, int deviceIndex) {
        return TornadoRuntimeProvider.getTornadoRuntime().getBackend(driverIndex).getDevice(deviceIndex);
    }

    public static int getTotalPlans() {
        return globalExecutionPlanCounter.intValue();
    }

    public static TornadoDeviceMap getTornadoDeviceMap() {
        return new TornadoDeviceMap();
    }

    public TornadoExecutionResult execute() {
        this.tornadoExecutor.execute(this.executionFrame);
        TornadoProfilerResult profilerResult = new TornadoProfilerResult(this.tornadoExecutor, this.getTraceExecutionPlan());
        TornadoExecutionResult executionResult = new TornadoExecutionResult(profilerResult);
        this.planResults.add(executionResult);
        this.tornadoExecutor.updateLastExecutedTaskGraph();
        return executionResult;
    }

    public TornadoExecutionPlan withGraph(int graphIndex) {
        this.tornadoExecutor.selectGraph(graphIndex);
        if (this.executionFrame.getGridScheduler() != null) {
            this.tornadoExecutor.withGridScheduler(this.executionFrame.getGridScheduler());
        }
        return new WithGraph(this, graphIndex);
    }

    public TornadoExecutionPlan withAllGraphs() {
        this.tornadoExecutor.selectAll();
        return new WithAllGraphs(this);
    }

    public TornadoExecutionPlan withPreCompilation() {
        this.tornadoExecutor.withPreCompilation(this.executionFrame);
        return new WithPreCompilation(this);
    }

    public TornadoExecutionPlan withDevice(TornadoDevice device) {
        this.tornadoExecutor.setDevice(device);
        return new WithDevice(this, device);
    }

    public void printTraceExecutionPlan() {
        System.out.println(Objects.requireNonNullElse(this.childLink, this));
    }

    public String getTraceExecutionPlan() {
        if (this.childLink != null) {
            return this.childLink.toString();
        }
        return this.toString();
    }

    public String toString() {
        return "Root";
    }

    public TornadoExecutionPlan withDevice(String taskName, TornadoDevice device) {
        this.tornadoExecutor.setDevice(taskName, device);
        return new WithDevice(this, device);
    }

    public TornadoExecutionPlan withConcurrentDevices() {
        this.tornadoExecutor.withConcurrentDevices();
        return new WithConcurrentDevices(this);
    }

    public TornadoExecutionPlan withoutConcurrentDevices() {
        this.tornadoExecutor.withoutConcurrentDevices();
        return new OffConcurrentDevices(this);
    }

    public TornadoDevice getDevice(int immutableTaskGraphIndex) {
        return this.tornadoExecutor.getDevice(immutableTaskGraphIndex);
    }

    public TornadoExecutionPlan freeDeviceMemory() {
        this.tornadoExecutor.freeDeviceMemory();
        return new WithFreeDeviceMemory(this);
    }

    public TornadoExecutionPlan withGridScheduler(GridScheduler gridScheduler) {
        boolean isGridRegistered = this.tornadoExecutor.withGridScheduler(gridScheduler);
        if (!isGridRegistered && !(isGridRegistered = this.tornadoExecutor.checkAllTaskGraphsForGridScheduler())) {
            throw new TornadoRuntimeException("[ERROR] GridScheduler Name not registered in any task-graph");
        }
        this.executionFrame.setGridScheduler(gridScheduler);
        return new WithGridScheduler(this, gridScheduler);
    }

    public TornadoExecutionPlan withDefaultScheduler() {
        this.tornadoExecutor.withDefaultScheduler();
        return new WithDefaultScheduler(this);
    }

    public TornadoExecutionPlan withBatch(String batchSize) {
        this.tornadoExecutor.withBatch(batchSize);
        return new WithBatch(this, batchSize);
    }

    public TornadoExecutionPlan withProfiler(ProfilerMode profilerMode) {
        this.executionFrame.setProfilerMode(profilerMode);
        return new WithProfiler(this, profilerMode);
    }

    public TornadoExecutionPlan withoutProfiler() {
        this.executionFrame.setProfilerOff();
        return new OffProfiler(this);
    }

    public TornadoExecutionPlan withMemoryLimit(String memoryLimit) {
        this.tornadoExecutor.withMemoryLimit(memoryLimit);
        return new WithMemoryLimit(this, memoryLimit);
    }

    public TornadoExecutionPlan withoutMemoryLimit() {
        this.tornadoExecutor.withoutMemoryLimit();
        return new OffMemoryLimit(this);
    }

    public TornadoExecutionPlan resetDevice() {
        this.tornadoExecutor.resetDevice();
        return new WithResetDevice(this);
    }

    public long getId() {
        return this.executionFrame.getExecutionPlanId();
    }

    public long getGlobalExecutionPlansCounter() {
        return globalExecutionPlanCounter.get();
    }

    public TornadoExecutionPlan clearProfiles() {
        this.tornadoExecutor.clearProfiles();
        return new WithClearProfiles(this);
    }

    public TornadoExecutionPlan withThreadInfo() {
        this.tornadoExecutor.withThreadInfo();
        return new WithThreadInfo(this);
    }

    public TornadoExecutionPlan withoutThreadInfo() {
        this.tornadoExecutor.withoutThreadInfo();
        return new OffThreadInfo(this);
    }

    public TornadoExecutionPlan withPrintKernel() {
        this.tornadoExecutor.withPrintKernel();
        return new WithPrintKernel(this);
    }

    public TornadoExecutionPlan withoutPrintKernel() {
        this.tornadoExecutor.withoutPrintKernel();
        return new OffPrintKernel(this);
    }

    public TornadoExecutionPlan withCompilerFlags(TornadoVMBackendType backend, String compilerFlags) {
        this.tornadoExecutor.withCompilerFlags(backend, compilerFlags);
        return new WithCompilerFlags(this, compilerFlags);
    }

    @Override
    public void close() throws TornadoExecutionPlanException {
        this.tornadoExecutor.freeDeviceMemory();
    }

    public long getCurrentDeviceMemoryUsage() {
        return this.tornadoExecutor.getCurrentDeviceMemoryUsage();
    }

    public TornadoExecutionResult getPlanResult(int index) {
        if (index >= this.planResults.size()) {
            throw new TornadoRuntimeException("[ERROR] Execution result not found");
        }
        return this.planResults.get(index);
    }

    public void mapOnDeviceMemoryRegion(Object destTornadoArray, Object srcTornadoArray, long offset, int fromGraphIndex, int toGraphIndex) {
        this.tornadoExecutor.mapOnDeviceMemoryRegion(destTornadoArray, srcTornadoArray, offset, fromGraphIndex, toGraphIndex);
    }

    public TornadoExecutionPlan withWarmUpTime(long milliseconds) throws InterruptedException {
        if (milliseconds < 0L) {
            throw new TornadoRuntimeException("[ERROR] Warm-up time cannot be negative");
        }
        this.tornadoExecutor.withWarmUpTime(milliseconds, this.executionFrame);
        return new WithWarmUpTime(this, milliseconds);
    }

    public TornadoExecutionPlan withWarmUpIterations(int iterations) {
        if (iterations < 0) {
            throw new TornadoRuntimeException("[ERROR] Warm-up time cannot be negative");
        }
        this.tornadoExecutor.withWarmUpIterations(iterations, this.executionFrame);
        return new WithWarmUpIterations(this, iterations);
    }
}

