/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import uk.ac.manchester.tornado.api.AccessorParameters;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraphInterface;
import uk.ac.manchester.tornado.api.TornadoTaskGraphInterface;
import uk.ac.manchester.tornado.api.common.PrebuiltTaskPackage;
import uk.ac.manchester.tornado.api.common.TaskPackage;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.common.TornadoFunctions;
import uk.ac.manchester.tornado.api.enums.ProfilerMode;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoTaskRuntimeException;
import uk.ac.manchester.tornado.api.runtime.ExecutorFrame;
import uk.ac.manchester.tornado.api.runtime.TornadoAPIProvider;

public class TaskGraph
implements TaskGraphInterface {
    private static final String ERROR_TASK_NAME_DUPLICATION = "[TornadoVM ERROR]. There are more than 1 tasks with the same task-name. Use different a different task name for each task within a TaskGraph.";
    private final String taskGraphName;
    protected TornadoTaskGraphInterface taskGraphImpl;
    protected HashSet<String> taskNames;

    public TaskGraph(String name) {
        this.taskGraphName = name;
        this.taskGraphImpl = TornadoAPIProvider.loadScheduleRuntime(name);
        this.taskNames = new HashSet();
    }

    @Override
    public TaskGraph addTask(TaskPackage taskPackage) {
        this.taskGraphImpl.addTask(taskPackage);
        return this;
    }

    @Override
    public TaskGraph task(String id, TornadoFunctions.Task code) {
        this.checkTaskName(id);
        TaskPackage taskPackage = TaskPackage.createPackage(id, code);
        this.taskGraphImpl.addTask(taskPackage);
        return this;
    }

    @Override
    public <T1> TaskGraph task(String id, TornadoFunctions.Task1<T1> code, T1 arg) {
        this.checkTaskName(id);
        TaskPackage taskPackage = TaskPackage.createPackage(id, code, arg);
        this.taskGraphImpl.addTask(taskPackage);
        return this;
    }

    @Override
    public <T1, T2> TaskGraph task(String id, TornadoFunctions.Task2<T1, T2> code, T1 arg1, T2 arg2) {
        this.checkTaskName(id);
        TaskPackage taskPackage = TaskPackage.createPackage(id, code, arg1, arg2);
        this.taskGraphImpl.addTask(taskPackage);
        return this;
    }

    @Override
    public <T1, T2, T3> TaskGraph task(String id, TornadoFunctions.Task3<T1, T2, T3> code, T1 arg1, T2 arg2, T3 arg3) {
        this.checkTaskName(id);
        TaskPackage taskPackage = TaskPackage.createPackage(id, code, arg1, arg2, arg3);
        this.taskGraphImpl.addTask(taskPackage);
        return this;
    }

    @Override
    public <T1, T2, T3, T4> TaskGraph task(String id, TornadoFunctions.Task4<T1, T2, T3, T4> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
        this.checkTaskName(id);
        TaskPackage taskPackage = TaskPackage.createPackage(id, code, arg1, arg2, arg3, arg4);
        this.taskGraphImpl.addTask(taskPackage);
        return this;
    }

    @Override
    public <T1, T2, T3, T4, T5> TaskGraph task(String id, TornadoFunctions.Task5<T1, T2, T3, T4, T5> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5) {
        this.checkTaskName(id);
        TaskPackage taskPackage = TaskPackage.createPackage(id, code, arg1, arg2, arg3, arg4, arg5);
        this.taskGraphImpl.addTask(taskPackage);
        return this;
    }

    @Override
    public <T1, T2, T3, T4, T5, T6> TaskGraph task(String id, TornadoFunctions.Task6<T1, T2, T3, T4, T5, T6> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6) {
        this.checkTaskName(id);
        TaskPackage taskPackage = TaskPackage.createPackage(id, code, arg1, arg2, arg3, arg4, arg5, arg6);
        this.taskGraphImpl.addTask(taskPackage);
        return this;
    }

    @Override
    public <T1, T2, T3, T4, T5, T6, T7> TaskGraph task(String id, TornadoFunctions.Task7<T1, T2, T3, T4, T5, T6, T7> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7) {
        this.checkTaskName(id);
        TaskPackage taskPackage = TaskPackage.createPackage(id, code, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        this.taskGraphImpl.addTask(taskPackage);
        return this;
    }

    @Override
    public <T1, T2, T3, T4, T5, T6, T7, T8> TaskGraph task(String id, TornadoFunctions.Task8<T1, T2, T3, T4, T5, T6, T7, T8> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8) {
        this.checkTaskName(id);
        TaskPackage taskPackage = TaskPackage.createPackage(id, code, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
        this.taskGraphImpl.addTask(taskPackage);
        return this;
    }

    @Override
    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> TaskGraph task(String id, TornadoFunctions.Task9<T1, T2, T3, T4, T5, T6, T7, T8, T9> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9) {
        this.checkTaskName(id);
        TaskPackage taskPackage = TaskPackage.createPackage(id, code, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
        this.taskGraphImpl.addTask(taskPackage);
        return this;
    }

    @Override
    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> TaskGraph task(String id, TornadoFunctions.Task10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10) {
        this.checkTaskName(id);
        TaskPackage taskPackage = TaskPackage.createPackage(id, code, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
        this.taskGraphImpl.addTask(taskPackage);
        return this;
    }

    @Override
    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> TaskGraph task(String id, TornadoFunctions.Task11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11) {
        this.checkTaskName(id);
        TaskPackage taskPackage = TaskPackage.createPackage(id, code, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
        this.taskGraphImpl.addTask(taskPackage);
        return this;
    }

    @Override
    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> TaskGraph task(String id, TornadoFunctions.Task12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12) {
        this.checkTaskName(id);
        TaskPackage taskPackage = TaskPackage.createPackage(id, code, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
        this.taskGraphImpl.addTask(taskPackage);
        return this;
    }

    @Override
    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> TaskGraph task(String id, TornadoFunctions.Task13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13) {
        this.checkTaskName(id);
        TaskPackage taskPackage = TaskPackage.createPackage(id, code, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13);
        this.taskGraphImpl.addTask(taskPackage);
        return this;
    }

    @Override
    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> TaskGraph task(String id, TornadoFunctions.Task14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13, T14 arg14) {
        this.checkTaskName(id);
        TaskPackage taskPackage = TaskPackage.createPackage(id, code, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14);
        this.taskGraphImpl.addTask(taskPackage);
        return this;
    }

    @Override
    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> TaskGraph task(String id, TornadoFunctions.Task15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13, T14 arg14, T15 arg15) {
        this.checkTaskName(id);
        TaskPackage taskPackage = TaskPackage.createPackage(id, code, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15);
        this.taskGraphImpl.addTask(taskPackage);
        return this;
    }

    @Override
    public TaskGraph prebuiltTask(String id, String entryPoint, String filename, AccessorParameters accessorParameters) {
        this.checkTaskName(id);
        PrebuiltTaskPackage prebuiltTask = TaskPackage.createPrebuiltTask(id, entryPoint, filename, accessorParameters);
        this.taskGraphImpl.addPrebuiltTask(prebuiltTask);
        return this;
    }

    @Override
    public TaskGraph prebuiltTask(String id, String entryPoint, String filename, AccessorParameters accessorParameters, int[] atomics) {
        this.checkTaskName(id);
        PrebuiltTaskPackage prebuiltTask = TaskPackage.createPrebuiltTask(id, entryPoint, filename, accessorParameters);
        prebuiltTask.withAtomics(atomics);
        this.taskGraphImpl.addPrebuiltTask(prebuiltTask);
        return this;
    }

    @Override
    public String getTaskGraphName() {
        return this.taskGraphName;
    }

    @Override
    public TaskGraph transferToDevice(int mode, Object ... objects) {
        this.taskGraphImpl.transferToDevice(mode, objects);
        return this;
    }

    @Override
    public TaskGraph consumeFromDevice(String uniqueTaskGraphName, Object ... objects) {
        this.taskGraphImpl.consumeFromDevice(uniqueTaskGraphName, objects);
        return this;
    }

    @Override
    public TaskGraph consumeFromDevice(Object ... objects) {
        this.taskGraphImpl.consumeFromDevice(this.taskGraphName, objects);
        return this;
    }

    @Override
    public TaskGraph transferToHost(int mode, Object ... objects) {
        this.taskGraphImpl.transferToHost(mode, objects);
        return this;
    }

    @Override
    public TaskGraph persistOnDevice(Object ... objects) {
        this.taskGraphImpl.transferToHost(2, objects);
        return this;
    }

    @Override
    public ImmutableTaskGraph snapshot() {
        TaskGraph cloneTaskGraph = new TaskGraph(this.getTaskGraphName());
        cloneTaskGraph.taskGraphImpl = this.taskGraphImpl.createImmutableTaskGraph();
        cloneTaskGraph.taskNames = this.taskNames;
        return new ImmutableTaskGraph(cloneTaskGraph);
    }

    void withoutMemoryLimit() {
        this.taskGraphImpl.withoutMemoryLimit();
    }

    private void checkTaskName(String id) {
        if (this.taskNames.contains(id)) {
            throw new TornadoTaskRuntimeException(ERROR_TASK_NAME_DUPLICATION);
        }
        this.taskNames.add(id);
    }

    void withDevice(TornadoDevice device) {
        this.taskGraphImpl.setDevice(device);
    }

    void withDevice(String taskName, TornadoDevice device) {
        this.taskGraphImpl.setDevice(taskName, device);
    }

    void batch(String batchSize) {
        this.taskGraphImpl.withBatch(batchSize);
    }

    void withMemoryLimit(String memoryLimit) {
        this.taskGraphImpl.withMemoryLimit(memoryLimit);
    }

    void execute(ExecutorFrame executionPackage) {
        this.taskGraphImpl.execute(executionPackage).waitOn();
    }

    void withPreCompilation(ExecutorFrame executionPackage) {
        this.taskGraphImpl.withPreCompilation(executionPackage);
    }

    void dumpProfiles() {
        this.taskGraphImpl.dumpProfiles();
    }

    void clearProfiles() {
        this.taskGraphImpl.clearProfiles();
    }

    void freeDeviceMemory() {
        this.taskGraphImpl.freeDeviceMemory();
    }

    void syncRuntimeTransferToHost(Object ... objects) {
        this.taskGraphImpl.syncRuntimeTransferToHost(objects);
    }

    void syncRuntimeTransferToHost(Object object, long offset, long partialCopySize) {
        this.taskGraphImpl.syncRuntimeTransferToHost(object, offset, partialCopySize);
    }

    TornadoDevice getDevice() {
        return this.taskGraphImpl.getDevice();
    }

    void useDefaultThreadScheduler(boolean use) {
        this.taskGraphImpl.useDefaultThreadScheduler(use);
    }

    boolean isFinished() {
        return this.taskGraphImpl.isFinished();
    }

    public Set<Object> getArgumentsLookup() {
        return this.taskGraphImpl.getArgumentsLookup();
    }

    long getTotalTime() {
        return this.taskGraphImpl.getTotalTime();
    }

    long getCompileTime() {
        return this.taskGraphImpl.getCompileTime();
    }

    long getTornadoCompilerTime() {
        return this.taskGraphImpl.getTornadoCompilerTime();
    }

    long getDriverInstallTime() {
        return this.taskGraphImpl.getDriverInstallTime();
    }

    long getDataTransfersTime() {
        return this.taskGraphImpl.getDataTransfersTime();
    }

    long getWriteTime() {
        return this.taskGraphImpl.getDeviceWriteTime();
    }

    long getReadTime() {
        return this.taskGraphImpl.getDeviceReadTime();
    }

    long getDataTransferDispatchTime() {
        return this.taskGraphImpl.getDataTransferDispatchTime();
    }

    long getKernelDispatchTime() {
        return this.taskGraphImpl.getKernelDispatchTime();
    }

    long getDeviceKernelTime() {
        return this.taskGraphImpl.getDeviceKernelTime();
    }

    long getTotalBytesCopyIn() {
        return this.taskGraphImpl.getTotalBytesCopyIn();
    }

    long getTotalBytesCopyOut() {
        return this.taskGraphImpl.getTotalBytesCopyOut();
    }

    protected String getProfileLog() {
        return this.taskGraphImpl.getProfileLog();
    }

    void enableProfiler(ProfilerMode profilerMode) {
        this.taskGraphImpl.enableProfiler(profilerMode);
    }

    void withConcurrentDevices() {
        this.taskGraphImpl.withConcurrentDevices();
    }

    void withoutConcurrentDevices() {
        this.taskGraphImpl.withoutConcurrentDevices();
    }

    void withThreadInfo() {
        this.taskGraphImpl.withThreadInfo();
    }

    void withoutThreadInfo() {
        this.taskGraphImpl.withoutThreadInfo();
    }

    void withPrintKernel() {
        this.taskGraphImpl.withPrintKernel();
    }

    void withoutPrintKernel() {
        this.taskGraphImpl.withoutPrintKernel();
    }

    void withCompilerFlags(TornadoVMBackendType backendType, String compilerFlags) {
        this.taskGraphImpl.withCompilerFlags(backendType, compilerFlags);
    }

    void withGridScheduler(GridScheduler gridScheduler) {
        this.taskGraphImpl.withGridScheduler(gridScheduler);
    }

    long getTotalBytesTransferred() {
        return this.taskGraphImpl.getTotalBytesTransferred();
    }

    long getTotalDeviceMemoryUsage() {
        return this.taskGraphImpl.getTotalDeviceMemoryUsage();
    }

    long getCurrentDeviceMemoryUsage() {
        return this.taskGraphImpl.getCurrentDeviceMemoryUsage();
    }

    void mapOnDeviceMemoryRegion(Object destArray, Object srcArray, long offset, TornadoTaskGraphInterface taskGraphSrc) {
        this.taskGraphImpl.mapOnDeviceMemoryRegion(destArray, srcArray, offset, taskGraphSrc);
    }

    void setLastExecutedTaskGraph(TornadoTaskGraphInterface lastExecutedTaskGraph) {
        this.taskGraphImpl.setLastExecutedTaskGraph(lastExecutedTaskGraph);
    }

    public Collection<?> getOutputs() {
        return this.taskGraphImpl.getOutputs();
    }

    TornadoTaskGraphInterface getTaskGraphImpl() {
        return this.taskGraphImpl;
    }

    public boolean isGridRegistered() {
        return this.taskGraphImpl.isGridRegistered();
    }
}

