/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import uk.ac.manchester.tornado.annotation.ASMMethodVisitor;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.runtime.ASMClassVisitorProvider;
import uk.ac.manchester.tornado.runtime.common.ParallelAnnotationProvider;

public class ASMClassVisitor
extends ClassVisitor
implements ASMClassVisitorProvider {
    private List<ParallelAnnotationProvider> parallelAnnotations;
    private ResolvedJavaMethod resolvedJavaMethod;

    public ASMClassVisitor() {
        super(589824);
    }

    public ASMClassVisitor(int i, ClassVisitor classVisitor, ResolvedJavaMethod resolvedJavaMethod) {
        super(i, classVisitor);
        this.parallelAnnotations = new ArrayList<ParallelAnnotationProvider>();
        this.resolvedJavaMethod = resolvedJavaMethod;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (name.equals(this.resolvedJavaMethod.getName()) && descriptor.equals(this.resolvedJavaMethod.getSignature().toMethodDescriptor())) {
            return new ASMMethodVisitor(this.api, this.cv.visitMethod(access, name, descriptor, signature, exceptions), this.parallelAnnotations);
        }
        return null;
    }

    public ParallelAnnotationProvider[] getParallelAnnotations(ResolvedJavaMethod method) {
        String methodClassFile = method.getDeclaringClass().getName().replaceFirst("L", "").replaceFirst(";", ".class");
        InputStream inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream(methodClassFile);
        try {
            ClassReader classReader = new ClassReader(inputStream);
            ClassWriter cw = new ClassWriter(1);
            ASMClassVisitor visitor = new ASMClassVisitor(589824, (ClassVisitor)cw, method);
            classReader.accept((ClassVisitor)visitor, 0);
            ParallelAnnotationProvider[] parallelAnnotation = new ParallelAnnotationProvider[visitor.parallelAnnotations.size()];
            return visitor.parallelAnnotations.toArray(parallelAnnotation);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TornadoRuntimeException("[ERROR] Class reader could not be instantiated for class file: " + methodClassFile);
        }
    }
}

