/*
 * Decompiled with CFR 0.152.
 */
package com.github.cowwoc.pouch.core;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class WrappedCheckedException
extends RuntimeException {
    private static final long serialVersionUID = 0L;

    private WrappedCheckedException(String message, Throwable cause) {
        super(message, cause);
        if (message == null) {
            throw new NullPointerException("message may not be null");
        }
        if (cause == null) {
            throw new NullPointerException("cause may not be null");
        }
    }

    private WrappedCheckedException(Throwable cause) {
        super(cause);
        if (cause == null) {
            throw new NullPointerException("cause may not be null");
        }
    }

    public static <V> V wrap(Callable<V> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw WrappedCheckedException.wrap(e);
        }
    }

    public static void wrap(CallableWithoutReturnValue callableWithoutReturnValue) {
        try {
            callableWithoutReturnValue.run();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw WrappedCheckedException.wrap(e);
        }
    }

    public static RuntimeException wrap(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof ExecutionException) {
            ExecutionException ee = (ExecutionException)t;
            return WrappedCheckedException.wrap(ee.getCause());
        }
        return new WrappedCheckedException(t);
    }

    @FunctionalInterface
    public static interface CallableWithoutReturnValue {
        public void run() throws Exception;
    }
}

