/*
 * Decompiled with CFR 0.152.
 */
package com.github.cowwoc.pouch.core;

import com.github.cowwoc.pouch.core.AbstractLazyReference;
import com.github.cowwoc.pouch.core.Factory;
import com.github.cowwoc.pouch.core.WrappedCheckedException;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class LazyFactory<T>
extends AbstractLazyReference<T>
implements Factory<T> {
    private boolean closed;

    public static <T> LazyFactory<T> create(final Supplier<T> supplier, final Consumer<T> disposer) {
        return new LazyFactory<T>(){

            @Override
            protected T createValue() {
                return supplier.get();
            }

            @Override
            protected void disposeValue(T value) {
                disposer.accept(value);
            }
        };
    }

    public static <T extends AutoCloseable> LazyFactory<T> create(Supplier<T> supplier) {
        return LazyFactory.create(supplier, value -> WrappedCheckedException.wrap(value::close));
    }

    protected abstract void disposeValue(T var1);

    @Override
    public final T getValue() {
        if (this.closed) {
            throw new IllegalStateException("Factory is closed");
        }
        return super.getValue();
    }

    @Override
    public final void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.isInitialized()) {
            return;
        }
        Object value = super.getValue();
        this.disposeValue(value);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("LazyFactory\n{\n  initialized: " + this.isInitialized());
        if (this.isInitialized()) {
            result.append(",\n").append("  value: ").append(this.getValue());
        }
        result.append("\n").append("  closed: ").append(this.closed).append("\n").append("}");
        return result.toString();
    }
}

