/*
 * Decompiled with CFR 0.152.
 */
package com.github.cowwoc.pouch.core;

import com.github.cowwoc.pouch.core.Reference;
import java.util.function.Supplier;

public abstract class ConcurrentLazyReference<T>
implements Reference<T> {
    private volatile boolean initialized;
    private T value;

    public static <T> ConcurrentLazyReference<T> create(final Supplier<T> supplier) {
        return new ConcurrentLazyReference<T>(){

            @Override
            protected T createValue() {
                return supplier.get();
            }
        };
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T getValue() {
        if (!this.initialized) {
            ConcurrentLazyReference concurrentLazyReference = this;
            synchronized (concurrentLazyReference) {
                if (!this.initialized) {
                    this.value = this.createValue();
                    this.initialized = true;
                }
            }
        }
        return this.value;
    }

    protected abstract T createValue();

    public String toString() {
        StringBuilder result = new StringBuilder("ConcurrentLazyReference\n{\n  initialized: " + this.initialized);
        if (this.initialized) {
            result.append(",\n").append("  value: ").append(this.value);
        }
        result.append("\n").append("}");
        return result.toString();
    }
}

