/*
 * Decompiled with CFR 0.152.
 */
package com.github.cowwoc.pouch.core;

import com.github.cowwoc.pouch.core.Factory;
import com.github.cowwoc.pouch.core.WrappedCheckedException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class ConcurrentLazyFactory<T>
implements Factory<T> {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private boolean initialized;
    private boolean closed;
    private T value;

    public static <T> ConcurrentLazyFactory<T> create(final Supplier<T> supplier, final Consumer<T> disposer) {
        return new ConcurrentLazyFactory<T>(){

            @Override
            protected T createValue() {
                return supplier.get();
            }

            @Override
            protected void disposeValue(T value) {
                disposer.accept(value);
            }
        };
    }

    public static <T extends AutoCloseable> ConcurrentLazyFactory<T> create(Supplier<T> supplier) {
        return ConcurrentLazyFactory.create(supplier, value -> WrappedCheckedException.wrap(value::close));
    }

    protected abstract T createValue();

    protected abstract void disposeValue(T var1);

    @Override
    public final T getValue() {
        this.readLock.lock();
        try {
            if (this.closed) {
                throw new IllegalStateException("Factory is closed");
            }
            if (!this.initialized) {
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    if (this.closed) {
                        throw new IllegalStateException("Factory is closed");
                    }
                    if (!this.initialized) {
                        this.value = this.createValue();
                        this.initialized = true;
                    }
                }
                finally {
                    this.writeLock.unlock();
                    this.readLock.lock();
                }
            }
            T t = this.value;
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public final void close() {
        this.readLock.lock();
        try {
            if (this.closed) {
                return;
            }
            this.readLock.unlock();
            this.writeLock.lock();
            try {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                if (!this.initialized) {
                    return;
                }
                this.disposeValue(this.value);
            }
            finally {
                this.writeLock.unlock();
                this.readLock.lock();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder("ConcurrentLazyFactory\n{\n  initialized: " + this.initialized);
        if (this.initialized) {
            result.append(",\n").append("  value: ").append(this.getValue());
        }
        result.append("\n").append("  closed: ").append(this.closed).append("\n").append("}");
        return result.toString();
    }
}

