/*
 * Decompiled with CFR 0.152.
 */
package com.github.cowwoc.pouch.core;

import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConcurrentChildScopes {
    private final ConcurrentMap<AutoCloseable, Thread> childScopeToCreator = new ConcurrentHashMap<AutoCloseable, Thread>();
    private final Phaser openScopes = new Phaser();
    private final Logger log = LoggerFactory.getLogger(ConcurrentChildScopes.class);

    public ConcurrentChildScopes() {
        this.openScopes.register();
    }

    public <T extends AutoCloseable> T createChildScope(Supplier<T> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier may not be null");
        }
        this.openScopes.register();
        try {
            AutoCloseable result = (AutoCloseable)supplier.get();
            this.childScopeToCreator.put(result, Thread.currentThread());
            return (T)result;
        }
        catch (RuntimeException e) {
            this.openScopes.arriveAndDeregister();
            throw e;
        }
    }

    public boolean onClosed(AutoCloseable scope) {
        boolean result;
        boolean bl = result = this.childScopeToCreator.remove(scope) != null;
        if (result) {
            this.openScopes.arriveAndDeregister();
        }
        return result;
    }

    public boolean close(Duration timeout) {
        boolean result;
        try {
            this.openScopes.awaitAdvanceInterruptibly(this.openScopes.arriveAndDeregister(), timeout.toMillis(), TimeUnit.MILLISECONDS);
            result = true;
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted while waiting for child scopes to shut down", (Throwable)e);
            result = false;
        }
        catch (TimeoutException e) {
            this.log.warn("Child scopes leaked. Here is a mapping from each leaked scope to the thread that created it: {}", this.childScopeToCreator, (Object)e);
            result = false;
        }
        for (AutoCloseable scope : this.childScopeToCreator.keySet()) {
            try {
                scope.close();
            }
            catch (Exception e) {
                this.log.warn("Failed to close scope: {}", (Object)scope, (Object)e);
            }
        }
        this.childScopeToCreator.clear();
        return result;
    }
}

